const { contextBridge, ipcRenderer } = require('electron');

contextBridge.exposeInMainWorld('desktopBridge', {
  isDesktop: true,
  showUI: () => ipcRenderer.invoke('desktop:show-ui'),
  pickWorkspaceFolder: () => ipcRenderer.invoke('desktop:pick-workspace-folder'),
  voiceToggle: (enabled) => ipcRenderer.invoke('desktop:voice-toggle', enabled),
  voiceListen: () => ipcRenderer.invoke('desktop:voice-listen'),
  getPersona: () => ipcRenderer.invoke('desktop:get-persona'),
  updatePersona: (data) => ipcRenderer.invoke('desktop:update-persona', data),
  toggleTheme: () => ipcRenderer.invoke('desktop:toggle-theme'),
  toggleFocusMode: () => ipcRenderer.invoke('desktop:toggle-focus-mode'),
  runSkill: (name) => ipcRenderer.invoke('desktop:run-skill', name),
  onThemeChange: (callback) => {
    const handler = (_, theme) => callback(theme);
    ipcRenderer.on('desktop:theme-change', handler);
    return () => ipcRenderer.removeListener('desktop:theme-change', handler);
  },
  onFocusModeToggle: (callback) => {
    const handler = () => callback();
    ipcRenderer.on('desktop:focus-mode-toggled', handler);
    return () => ipcRenderer.removeListener('desktop:focus-mode-toggled', handler);
  },
  onOpenPersonaEditor: (callback) => {
    const handler = () => callback();
    ipcRenderer.on('desktop:open-persona-editor', handler);
    return () => ipcRenderer.removeListener('desktop:open-persona-editor', handler);
  },
  onStreamChunk: (callback) => {
    const handler = (_, data) => callback(data);
    ipcRenderer.on('desktop:stream-chunk', handler);
    return () => ipcRenderer.removeListener('desktop:stream-chunk', handler);
  },
  onStreamEnd: (callback) => {
    const handler = (_, data) => callback(data);
    ipcRenderer.on('desktop:stream-end', handler);
    return () => ipcRenderer.removeListener('desktop:stream-end', handler);
  }
});
