#!/bin/bash
# Bootstrap installer for autonomous-agent
# Usage: curl -fsSL <url>/install.sh | bash -s my-agent-name

set -e

AGENT_NAME="${1:-my-agent}"

# Check prerequisites
command -v node >/dev/null 2>&1 || { echo "Error: Node.js is required. Install from https://nodejs.org"; exit 1; }
command -v git >/dev/null 2>&1 || { echo "Error: git is required."; exit 1; }

NODE_VERSION=$(node -v | sed 's/v//' | cut -d. -f1)
if [ "$NODE_VERSION" -lt 20 ]; then
  echo "Error: Node.js >= 20 required (you have $(node -v))"
  exit 1
fi

# Check for at least one LLM CLI
CLI="claude"
if command -v claude >/dev/null 2>&1; then
  CLI="claude"
elif command -v codex >/dev/null 2>&1; then
  CLI="codex"
elif command -v gemini >/dev/null 2>&1; then
  CLI="gemini"
else
  echo "Warning: No supported LLM CLI found (claude, codex, gemini)"
  echo "Install one before running the agent."
fi

echo "Creating agent: $AGENT_NAME (using $CLI)"

npx create-autonomous-agent "$AGENT_NAME"
