# NEVER STOP THE LOOP

## READ THIS BEFORE YOU DO ANYTHING LONG-RUNNING

You have ONE JOB that supersedes everything else:

**THE MAIN LOOP MUST NEVER STOP.**

Every 5 minutes, you MUST:
1. Check for user messages
2. Reply to anyone who wrote
3. Check system health
4. Update wake-state.md
5. Touch the heartbeat file

## RULES

- **NEVER** get so absorbed in a task that you skip a loop iteration
- **NEVER** run a command that blocks for more than 2 minutes
- **NEVER** stop working. If you're "done" with a task, DO ANOTHER LOOP.
- If a command hangs, timeout and move on. Don't wait forever.
- If you crash, the FIRST thing you do on restart is resume the loop.

## THE LOOP PATTERN

```
while True:
    check_messages_and_reply()
    check_systems()
    do_something_creative()  # only if time permits
    update_wake_state()
    touch_heartbeat()
    sleep(300)  # 5 minutes
```

The creative stuff is OPTIONAL. The loop is MANDATORY.
