@echo off
setlocal enabledelayedexpansion

:: Reset agent to a clean state (Windows)
:: Usage: reset.bat [--hard]
::
:: Default: Clears runtime state (db, journal, workspace, wake-state, evolution)
:: --hard:  Also removes config.json, node_modules/ (full reset)

echo.
echo   Resetting agent...
echo.

set HARD=false
if "%1"=="--hard" set HARD=true

:: Stop the agent if running
taskkill /f /fi "WINDOWTITLE eq node agent.mjs" >nul 2>&1

:: Remove database
if exist agent.db (
    echo   Removing database...
    del /f agent.db agent.db-shm agent.db-wal 2>nul
)

:: Clear journal
if exist journal.md (
    echo   Clearing journal...
    echo # Journal> journal.md
)

:: Reset wake state
if exist wake-state.md del /f wake-state.md
echo   Cleared wake state

:: Reset evolution state
if exist evolution.yaml del /f evolution.yaml
echo   Cleared evolution state

:: Clear heartbeat
if exist .heartbeat del /f .heartbeat

:: Clear workspaces and recreate default
if exist workspaces (
    echo   Clearing workspaces...
    rmdir /s /q workspaces
)
mkdir workspaces\default

:: Clear wake word recordings (preserve models)
if exist data\wake-words (
    echo   Clearing wake word recordings...
    del /q data\wake-words\*.wav data\wake-words\*.pcm 2>nul
)

:: Clear generated site
if exist site (
    echo   Removing generated site...
    rmdir /s /q site
)

:: Clear logs
del /f agent.log watchdog.log 2>nul

:: Clear uploads (ingestion temp files)
if exist uploads (
    echo   Clearing uploads...
    rmdir /s /q uploads
)

if "!HARD!"=="true" (
    echo.
    echo   Hard reset - removing config and dependencies...
    del /f config.json 2>nul
    if exist node_modules rmdir /s /q node_modules
    echo   Run setup.bat to reconfigure, or: npm install ^&^& npm start
)

echo.
echo   Reset complete. Run 'npm start' to start fresh.
echo.
pause
