import { ingest } from '../ingestion.mjs';

export const name = 'ingest';
export const description = 'Ingest a file, URL, or text into the knowledge graph';

export async function execute(ctx) {
  const source = ctx.args?.topic || ctx.args?.target || ctx.args?.task || '';
  if (!source) return { success: false, reply: 'No source provided. Please specify a file path, URL, or text to ingest.' };

  const workspaceId = ctx.getActiveWorkspaceId();
  try {
    const result = await ingest(source, { workspaceId, extractEntities: true });
    const entityCount = result.entities?.length || 0;
    const relationCount = result.relations?.length || 0;
    ctx.addEvent('skill', 'agent', `Ingested: ${source.slice(0, 100)}`, { skill: name, sourceType: result.sourceType, entities: entityCount, relations: relationCount });
    return { success: true, reply: `Ingested successfully. Extracted ${entityCount} entities and ${relationCount} relations.` };
  } catch (err) {
    return { success: false, reply: `Ingestion failed: ${err.message}` };
  }
}
