export const name = 'vision';
export const description = 'Analyze and describe images using vision AI';
export async function execute(ctx) {
  // ctx has: askLLM, pickModel, remember, recall, recallAll, addEvent, writeOutputFile, args
  const { describeImage, isVisionAvailable, getImageMetadata } = await import('../multimodal/vision.mjs');

  const target = ctx.args?.target || ctx.args?.topic || '';
  if (!target) {
    ctx.addEvent('skill', 'agent', 'Vision skill: no target file specified');
    return { success: false, error: 'No target file specified' };
  }

  try {
    const result = await describeImage(target, ctx.args?.prompt || 'Describe this image in detail.');
    ctx.addEvent('skill', 'agent', `Vision analysis: ${result.metadata.filename} → ${result.description.slice(0, 200)}`);
    return { success: true, ...result };
  } catch (err) {
    ctx.addEvent('skill', 'agent', `Vision skill failed: ${err.message}`);
    return { success: false, error: err.message };
  }
}
